using System;

class Program
{
    struct Vektor
    {
        public long x, y;
        public double angle;
        public int index;
    }

    static void Main(string[] args)
    {
        int n = int.Parse(Console.ReadLine());
        Vektor[] a = new Vektor[n];

        for (int i = 0; i < n; i++)
        {
            string[] s = Console.ReadLine().Split();
            long x = long.Parse(s[0]);
            long y = long.Parse(s[1]);

            a[i] = new Vektor
            {
                x = x,
                y = y,
                angle = Math.Atan2(y, x),
                index = i + 1
            };
        }

        Array.Sort(a, (p, q) => p.angle.CompareTo(q.angle));

        Vektor[] b = new Vektor[2 * n];
        for (int i = 0; i < n; i++)
        {
            b[i] = a[i];
            b[i + n] = a[i];
            b[i + n].angle += 2 * Math.PI;
        }

        long bestX = 0, bestY = 0;
        long curX = 0, curY = 0;
        int l = 0, bestL = 0, bestR = -1;

        for (int r = 0; r < 2 * n; r++)
        {
            curX += b[r].x;
            curY += b[r].y;

            while (b[r].angle - b[l].angle > Math.PI)
            {
                curX -= b[l].x;
                curY -= b[l].y;
                l++;
            }

            long curLen = curX * curX + curY * curY;
            long bestLen = bestX * bestX + bestY * bestY;

            if (curLen > bestLen)
            {
                bestX = curX;
                bestY = curY;
                bestL = l;
                bestR = r;
            }
        }

        List<int> result = new List<int>();
        for (int i = bestL; i <= bestR; i++)
            result.Add(b[i].index);

        Console.WriteLine(result.Count);
        foreach (int x in result)
            Console.Write(x + " ");
        Console.WriteLine();
    }
}